<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SyncData extends Model 
{

    protected $table = 'sync_data';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function dealer()
    {
        return $this->hasOne('App\Models\User');
    }

    public function frequency()
    {
        return $this->hasOne('App\Models\CronFrequency', 'cron_id');
    }

}